/*---------------------------------------------------------------------------*\

    FILE....: TCONF.CPP
    TYPE....: C++ Console program
    AUTHOR..: Ben Kramer
    DATE....: 26/02/03

    This program tests the conferencing on the OpenSwitch boards.

    1. Compile using 'make'
    2. connect some handsets
    3. Run this program with './tconf'
    4. All handsets should now be joined when off hook!
    5. Press return to exit.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"
#include "../src/mess.h"
#include "kbhit.h"

#define MAX_CH 100

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char *argv[])
{
	int		h[MAX_CH];
	VPB_EVENT	e;
	int	        ret,i,ch;
	char		s[VPB_MAX_STR];
	char            model_str[VPB_MAX_STR];
	int             ch_per_card, num_cards, num_members=3;
	

	if (argc ==2){
		num_members=atoi(argv[1]);
		printf("conferencing %d people\n",num_members);
	}
	verbose(1);
	vpb_seterrormode(VPB_DEVELOPMENT);
	
	h[0] = vpb_open(1,1);
	vpb_get_model(model_str);
	num_cards = vpb_get_num_cards();
	printf("model = %s\n", model_str);
	vpb_close(h[0]);
	
	if (!strcmp(model_str, "V12PCI")) {
	        ch_per_card = 12;
		ch = ch_per_card*num_cards;
	}
	if (!strcmp(model_str, "VPB4")) {
		printf("Only the OpenSwitch cards are supported!!\n");
		return(1);
	}
	for(i=0; i<ch; i++) {
		h[i] = vpb_open(1 + (i/ch_per_card) ,(i%ch_per_card)+1);
		vpb_sethook_sync(h[i],VPB_ONHOOK);
		vpb_play_set_hw_gain(h[i],8);
		vpb_record_set_hw_gain(h[i],-5);
	}
	printf("Started...\n");
		
	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
			if (e.type == VPB_STATION_OFFHOOK) {
				vpb_conf(e.handle,0,VPB_CONF_JOIN);
				printf("Joining Conf\n");
			}
			if (e.type == VPB_STATION_ONHOOK) {
				vpb_conf(e.handle,0,VPB_CONF_LEAVE);
				printf("Leaving Conf\n");
			}
			if (e.type == VPB_RING) {
				vpb_sethook_sync(e.handle,VPB_OFFHOOK);
				vpb_conf(e.handle,0,VPB_CONF_JOIN);
				printf("Joining Conf\n");
			}
			if (e.type == VPB_DROP) {
				vpb_conf(e.handle,0,VPB_CONF_LEAVE);
				printf("Leaving Conf\n");
				vpb_sethook_sync(e.handle,VPB_ONHOOK);
			}
		}
		vpb_sleep(100);

	} while(!kbhit());

	/*
	if (arg_exists(argc, argv, "--ringall"))
		for(i=0; i<ch; i++)
			vpb_ring_station_sync(h[i], VPB_RING_STATION_OFF);
	*/
		
	for(i=0; i<ch; i++) {
		vpb_close(h[i]);
	}

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}

